<?php
header("Content-Type: application/json");
include '../../config.php';

if (isset($_GET['unique_token'])) {
    $unique_token = $_GET['unique_token'];

    $sql = "SELECT status FROM registration_fee WHERE unique_token = ?";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("s", $unique_token);
        $stmt->execute();
        $stmt->bind_result($payment_status);
        $stmt->fetch();
        $stmt->close();

        if ($payment_status) {
            echo json_encode(['status' => $payment_status]);
        } else {
            echo json_encode(['status' => 'NOT_FOUND']);
        }
    } else {
        echo json_encode(['status' => 'ERROR', 'message' => $conn->error]);
    }
} else {
    echo json_encode(['status' => 'ERROR', 'message' => 'Unique token is required']);
}

$conn->close();
?>
