<?php
header("Content-Type: application/json");
include '../config.php';


// Pata branch_id na user_id kutoka kwa GET parameters
$branch_id = isset($_GET['branch_id']) ? intval($_GET['branch_id']) : 0;
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

// Query kwenye table ya expenditures
$sql = "SELECT id, price, description, date, user_id, branch_id FROM expenditures WHERE branch_id = ? AND user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $branch_id, $user_id);
$stmt->execute();
$result = $stmt->get_result();

$expenses = [];
while($row = $result->fetch_assoc()){
    $expenses[] = $row;
}

$stmt->close();
$conn->close();

echo json_encode($expenses);
?>
