<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

include '../../config.php';

// Pokea user_id kutoka kwa GET parameters
$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : 0;

if ($user_id == 0) {
    echo json_encode(["success" => false, "message" => "User ID is required"]);
    exit;
}

// Query ya kupata branches kwa user_id husika
$sql = "SELECT branch_id, user_id, branch_name, location, interest, form_fee, created_at FROM branches WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$branches = [];
while ($row = $result->fetch_assoc()) {
    $branches[] = $row;
}

$stmt->close();
$conn->close();

echo json_encode(["success" => true, "data" => $branches]);
?>
